<?php
require_once __DIR__ . '/vapi_config.php';

$pdo = new PDO(DB_DSN, DB_USER, DB_PASS, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
]);

// Get pending recordings
$stmt = $pdo->query("
    SELECT id, call_id, recording_url 
    FROM vapi_call_recordings 
    WHERE download_status = 'pending' AND recording_url IS NOT NULL
    LIMIT 10
");

$recordings_dir = __DIR__ . '/recordings/';
if (!is_dir($recordings_dir)) {
    mkdir($recordings_dir, 0755, true);
}

while ($row = $stmt->fetch()) {
    try {
        $file_content = file_get_contents($row['recording_url']);
        if ($file_content === false) throw new Exception('Failed to download');
        
        $filename = $row['call_id'] . '.wav'; // or .mp3 based on Vapi format
        $local_path = $recordings_dir . $filename;
        
        if (file_put_contents($local_path, $file_content)) {
            $update = $pdo->prepare("
                UPDATE vapi_call_recordings 
                SET local_file_path = ?, file_size_bytes = ?, download_status = 'downloaded'
                WHERE id = ?
            ");
            $update->execute([$local_path, strlen($file_content), $row['id']]);
            echo "Downloaded: {$row['call_id']}\n";
        }
    } catch (Exception $e) {
        $pdo->prepare("UPDATE vapi_call_recordings SET download_status = 'failed' WHERE id = ?")
            ->execute([$row['id']]);
        echo "Failed: {$row['call_id']} - {$e->getMessage()}\n";
    }
}