

<?php $__env->startSection('title', 'Admin Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-cog me-2"></i>
                    WhatsApp Configuration
                </h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    
                    <div class="mb-3">
                        <label for="meta_access_token" class="form-label">Meta Access Token</label>
                        <input type="password" 
                               class="form-control <?php $__errorArgs = ['meta_access_token'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="meta_access_token" 
                               name="meta_access_token" 
                               value="<?php echo e($settings->meta_access_token ?? ''); ?>" 
                               required>
                        <div class="form-text">Your permanent access token from Meta Developer Console</div>
                        <?php $__errorArgs = ['meta_access_token'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="mb-3">
                        <label for="phone_number_id" class="form-label">Phone Number ID</label>
                        <input type="text" 
                               class="form-control <?php $__errorArgs = ['phone_number_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="phone_number_id" 
                               name="phone_number_id" 
                               value="<?php echo e($settings->phone_number_id ?? ''); ?>" 
                               required>
                        <div class="form-text">Your WhatsApp Business Phone Number ID</div>
                        <?php $__errorArgs = ['phone_number_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="mb-3">
                        <label for="default_agent_id" class="form-label">Default Agent</label>
                        <select class="form-select <?php $__errorArgs = ['default_agent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="default_agent_id" 
                                name="default_agent_id">
                            <option value="">Select Default Agent</option>
                            <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($agent->id); ?>" 
                                        <?php echo e(($settings->default_agent_id ?? '') == $agent->id ? 'selected' : ''); ?>>
                                    <?php echo e($agent->username); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="form-text">Agent to assign new customers by default</div>
                        <?php $__errorArgs = ['default_agent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>
                            Save Settings
                        </button>
                        
                        <form action="<?php echo e(route('admin.sync.templates')); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                    class="btn btn-outline-primary"
                                    onclick="return confirm('Sync templates from WhatsApp?')">
                                <i class="fas fa-sync me-2"></i>
                                Sync Templates
                            </button>
                        </form>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>
                    Templates (<?php echo e($templates->count()); ?>)
                </h5>
            </div>
            <div class="card-body">
                <?php if($templates->count() > 0): ?>
                    <div class="list-group list-group-flush">
                        <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong><?php echo e($template->name); ?></strong>
                                    <br>
                                    <small class="text-muted"><?php echo e($template->language); ?> • <?php echo e($template->category); ?></small>
                                </div>
                                <span class="badge bg-success rounded-pill">Active</span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center text-muted">
                        <i class="fas fa-inbox fa-3x mb-3"></i>
                        <p>No templates synced yet.</p>
                        <p class="small">Click "Sync Templates" to import from WhatsApp.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Webhook URL
                </h5>
            </div>
            <div class="card-body">
                <div class="input-group">
                    <input type="text" 
                           class="form-control" 
                           value="<?php echo e(url('/api/webhook')); ?>" 
                           readonly>
                    <button class="btn btn-outline-secondary" 
                            type="button" 
                            onclick="copyToClipboard(this)">
                        <i class="fas fa-copy"></i>
                    </button>
                </div>
                <div class="form-text mt-2">
                    Use this URL in your Meta Developer Console webhook configuration.
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function copyToClipboard(button) {
    const input = button.parentElement.querySelector('input');
    input.select();
    document.execCommand('copy');
    
    const icon = button.querySelector('i');
    icon.className = 'fas fa-check';
    setTimeout(() => {
        icon.className = 'fas fa-copy';
    }, 2000);
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\maharaCRM\resources\views/admin/settings.blade.php ENDPATH**/ ?>