

<?php $__env->startSection('title', 'Agent Inbox'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-inbox me-2"></i>
                    Customer Conversations
                </h5>
                <span class="badge bg-primary" id="unread-badge" style="display: none;"></span>
            </div>
            <div class="card-body">
                <?php if(count($conversations) > 0): ?>
                    <div class="list-group">
                        <?php $__currentLoopData = $conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('agent.conversation', $conversation['customer_e164'])); ?>" 
                               class="list-group-item list-group-item-action d-flex justify-content-between align-items-start">
                                <div class="ms-2 me-auto">
                                    <div class="fw-bold">
                                        <i class="fab fa-whatsapp me-2 text-success"></i>
                                        <?php echo e($conversation['customer_e164']); ?>

                                    </div>
                                    <div class="text-muted small">
                                        <?php echo e(Str::limit($conversation['last_message']->content, 50)); ?>

                                    </div>
                                    <small class="text-muted">
                                        <?php echo e($conversation['last_message']->created_at->diffForHumans()); ?>

                                    </small>
                                </div>
                                <?php if($conversation['unread_count'] > 0): ?>
                                    <span class="badge bg-danger rounded-pill">
                                        <?php echo e($conversation['unread_count']); ?>

                                    </span>
                                <?php endif; ?>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No conversations yet</h5>
                        <p class="text-muted">When customers send messages, they will appear here.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
// Auto-refresh unread count every 30 seconds
setInterval(function() {
    fetch('<?php echo e(route("agent.unread.count")); ?>')
        .then(response => response.json())
        .then(data => {
            const badge = document.getElementById('unread-badge');
            if (data.unread_count > 0) {
                badge.textContent = data.unread_count;
                badge.style.display = 'inline';
            } else {
                badge.style.display = 'none';
            }
        });
}, 30000);
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\maharaCRM\resources\views/agent/inbox.blade.php ENDPATH**/ ?>