<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\MessagesController;
use App\Http\Controllers\AgentController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Authentication routes
Route::get('/', [AccountController::class, 'showLogin']);
Route::get('/login', [AccountController::class, 'showLogin'])->name('login');
Route::post('/login', [AccountController::class, 'login']);
Route::post('/logout', [AccountController::class, 'logout'])->name('logout');

// Admin routes
Route::prefix('admin')->group(function () {
    Route::get('/settings', [AdminController::class, 'settings'])->name('admin.settings');
    Route::post('/settings', [AdminController::class, 'updateSettings'])->name('admin.settings.update');
    Route::post('/sync-templates', [AdminController::class, 'syncTemplates'])->name('admin.sync.templates');
    
    Route::get('/users', [AdminController::class, 'users'])->name('admin.users');
    Route::post('/users', [AdminController::class, 'createUser'])->name('admin.users.create');
    Route::put('/users/{id}', [AdminController::class, 'updateUser'])->name('admin.users.update');
    Route::delete('/users/{id}', [AdminController::class, 'deleteUser'])->name('admin.users.delete');
    
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
});

// Agent routes
Route::prefix('agent')->group(function () {
    Route::get('/inbox', [AgentController::class, 'inbox'])->name('agent.inbox');
    Route::get('/conversation/{customerE164}', [AgentController::class, 'conversation'])->name('agent.conversation');
    Route::post('/conversation/{customerE164}/send', [AgentController::class, 'sendMessage'])->name('agent.send.message');
    Route::post('/conversation/{customerE164}/reassign', [AgentController::class, 'reassignCustomer'])->name('agent.reassign.customer');
    
    Route::get('/dashboard', [AgentController::class, 'dashboard'])->name('agent.dashboard');
    Route::get('/unread-count', [AgentController::class, 'getUnreadCount'])->name('agent.unread.count');
    Route::post('/mark-read/{customerE164}', [AgentController::class, 'markAsRead'])->name('agent.mark.read');
});

// Message routes
Route::prefix('messages')->group(function () {
    Route::get('/compose', [MessagesController::class, 'compose'])->name('messages.compose');
    Route::post('/send-template', [MessagesController::class, 'sendTemplate'])->name('messages.send.template');
    Route::post('/send-text', [MessagesController::class, 'sendText'])->name('messages.send.text');
    
    Route::get('/templates', [MessagesController::class, 'getTemplates'])->name('messages.templates');
    Route::get('/templates/{templateName}', [MessagesController::class, 'getTemplateDetails'])->name('messages.template.details');
    
    Route::get('/history/{customerE164}', [MessagesController::class, 'messageHistory'])->name('messages.history');
    Route::get('/status/{messageId}', [MessagesController::class, 'getMessageStatus'])->name('messages.status');
    Route::post('/resend/{messageId}', [MessagesController::class, 'resendMessage'])->name('messages.resend');
});
