<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WebhookController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// WhatsApp Webhook routes
Route::prefix('webhook')->group(function () {
    Route::get('/', [WebhookController::class, 'verify']);
    Route::post('/', [WebhookController::class, 'handle']);
});
