@extends('layouts.app')

@section('title', 'Compose Message')

@section('content')
<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-paper-plane me-2"></i>
                    Compose Message
                </h5>
            </div>
            <div class="card-body">
                <!-- Message Type Tabs -->
                <ul class="nav nav-tabs" id="messageTabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="template-tab" data-bs-toggle="tab" data-bs-target="#template" type="button" role="tab">
                            <i class="fas fa-file-alt me-2"></i>
                            Template Message
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="text-tab" data-bs-toggle="tab" data-bs-target="#text" type="button" role="tab">
                            <i class="fas fa-comment me-2"></i>
                            Text Message
                        </button>
                    </li>
                </ul>

                <div class="tab-content mt-3" id="messageTabsContent">
                    <!-- Template Message Tab -->
                    <div class="tab-pane fade show active" id="template" role="tabpanel">
                        <form action="{{ route('messages.send.template') }}" method="POST">
                            @csrf
                            
                            <div class="mb-3">
                                <label for="to" class="form-label">Recipient Phone Number</label>
                                <input type="text" 
                                       class="form-control @error('to') is-invalid @enderror" 
                                       id="to" 
                                       name="to" 
                                       placeholder="+1234567890" 
                                       required>
                                <div class="form-text">Enter phone number in international format (e.g., +1234567890)</div>
                                @error('to')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="template_name" class="form-label">Template</label>
                                <select class="form-select @error('template_name') is-invalid @enderror" 
                                        id="template_name" 
                                        name="template_name" 
                                        required>
                                    <option value="">Select a template</option>
                                    @foreach($templates as $template)
                                        <option value="{{ $template->name }}">
                                            {{ $template->name }} ({{ $template->language }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('template_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3" id="template-params" style="display: none;">
                                <label class="form-label">Template Parameters</label>
                                <div id="params-container">
                                    <!-- Dynamic parameters will be loaded here -->
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane me-2"></i>
                                Send Template Message
                            </button>
                        </form>
                    </div>

                    <!-- Text Message Tab -->
                    <div class="tab-pane fade" id="text" role="tabpanel">
                        <form action="{{ route('messages.send.text') }}" method="POST">
                            @csrf
                            
                            <div class="mb-3">
                                <label for="to_text" class="form-label">Recipient Phone Number</label>
                                <input type="text" 
                                       class="form-control @error('to') is-invalid @enderror" 
                                       id="to_text" 
                                       name="to" 
                                       placeholder="+1234567890" 
                                       required>
                                <div class="form-text">Enter phone number in international format (e.g., +1234567890)</div>
                                @error('to')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="content" class="form-label">Message Content</label>
                                <textarea class="form-control @error('content') is-invalid @enderror" 
                                          id="content" 
                                          name="content" 
                                          rows="5" 
                                          placeholder="Type your message here..." 
                                          maxlength="1000" 
                                          required></textarea>
                                <div class="form-text">
                                    <span id="char-count">0</span>/1000 characters
                                </div>
                                @error('content')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane me-2"></i>
                                Send Text Message
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Message Guidelines
                </h5>
            </div>
            <div class="card-body">
                <h6>Template Messages</h6>
                <ul class="small text-muted">
                    <li>Use pre-approved WhatsApp templates</li>
                    <li>No character limits</li>
                    <li>Can include dynamic parameters</li>
                    <li>Professional and consistent</li>
                </ul>

                <hr>

                <h6>Text Messages</h6>
                <ul class="small text-muted">
                    <li>Free-form text messages</li>
                    <li>Maximum 1000 characters</li>
                    <li>Immediate delivery</li>
                    <li>For quick responses</li>
                </ul>

                <hr>

                <h6>Best Practices</h6>
                <ul class="small text-muted">
                    <li>Always use international format for phone numbers</li>
                    <li>Test templates before sending to customers</li>
                    <li>Keep messages concise and clear</li>
                    <li>Respect customer privacy and preferences</li>
                </ul>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Character counter for text messages
document.getElementById('content').addEventListener('input', function() {
    const count = this.value.length;
    document.getElementById('char-count').textContent = count;
});

// Template parameter loading
document.getElementById('template_name').addEventListener('change', function() {
    const templateName = this.value;
    if (templateName) {
        fetch(`/messages/templates/${templateName}`)
            .then(response => response.json())
            .then(template => {
                if (template.template_data && template.template_data.components) {
                    showTemplateParams(template.template_data.components);
                } else {
                    hideTemplateParams();
                }
            })
            .catch(error => {
                console.error('Error loading template:', error);
                hideTemplateParams();
            });
    } else {
        hideTemplateParams();
    }
});

function showTemplateParams(components) {
    const container = document.getElementById('params-container');
    container.innerHTML = '';
    
    components.forEach((component, index) => {
        if (component.type === 'body' && component.example) {
            const div = document.createElement('div');
            div.className = 'mb-2';
            div.innerHTML = `
                <label class="form-label">Parameter ${index + 1}</label>
                <input type="text" class="form-control" name="params[body][${index}]" 
                       placeholder="${component.example.body_text[0] || 'Enter parameter'}">
            `;
            container.appendChild(div);
        }
    });
    
    document.getElementById('template-params').style.display = 'block';
}

function hideTemplateParams() {
    document.getElementById('template-params').style.display = 'none';
    document.getElementById('params-container').innerHTML = '';
}
</script>
@endpush
@endsection
