@extends('layouts.app')

@section('title', 'Agent Inbox')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fas fa-inbox me-2"></i>
                    Customer Conversations
                </h5>
                <span class="badge bg-primary" id="unread-badge" style="display: none;"></span>
            </div>
            <div class="card-body">
                @if(count($conversations) > 0)
                    <div class="list-group">
                        @foreach($conversations as $conversation)
                            <a href="{{ route('agent.conversation', $conversation['customer_e164']) }}" 
                               class="list-group-item list-group-item-action d-flex justify-content-between align-items-start">
                                <div class="ms-2 me-auto">
                                    <div class="fw-bold">
                                        <i class="fab fa-whatsapp me-2 text-success"></i>
                                        {{ $conversation['customer_e164'] }}
                                    </div>
                                    <div class="text-muted small">
                                        {{ Str::limit($conversation['last_message']->content, 50) }}
                                    </div>
                                    <small class="text-muted">
                                        {{ $conversation['last_message']->created_at->diffForHumans() }}
                                    </small>
                                </div>
                                @if($conversation['unread_count'] > 0)
                                    <span class="badge bg-danger rounded-pill">
                                        {{ $conversation['unread_count'] }}
                                    </span>
                                @endif
                            </a>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No conversations yet</h5>
                        <p class="text-muted">When customers send messages, they will appear here.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Auto-refresh unread count every 30 seconds
setInterval(function() {
    fetch('{{ route("agent.unread.count") }}')
        .then(response => response.json())
        .then(data => {
            const badge = document.getElementById('unread-badge');
            if (data.unread_count > 0) {
                badge.textContent = data.unread_count;
                badge.style.display = 'inline';
            } else {
                badge.style.display = 'none';
            }
        });
}, 30000);
</script>
@endpush
@endsection
