@extends('layouts.app')

@section('title', 'Agent Dashboard')

@section('content')
<div class="row">
    <!-- Statistics Cards -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Assigned Customers
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['assigned_customers'] }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Unread Messages
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['unread_messages'] }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-envelope fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Messages Today
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['messages_today'] }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-calendar fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Active Conversations
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['assigned_customers'] }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fab fa-whatsapp fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Recent Activity -->
    <div class="col-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">Recent Activity</h6>
                <a href="{{ route('agent.inbox') }}" class="btn btn-primary btn-sm">
                    <i class="fas fa-inbox me-1"></i>
                    View Inbox
                </a>
            </div>
            <div class="card-body">
                @if(count($stats['recent_activity']) > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Customer</th>
                                    <th>Type</th>
                                    <th>Content</th>
                                    <th>Status</th>
                                    <th>Time</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($stats['recent_activity'] as $message)
                                    <tr>
                                        <td>
                                            <a href="{{ route('agent.conversation', $message->customer_e164) }}">
                                                {{ $message->customer_e164 }}
                                            </a>
                                        </td>
                                        <td>
                                            @if($message->direction === 'inbound')
                                                <span class="badge bg-success">Inbound</span>
                                            @else
                                                <span class="badge bg-primary">Outbound</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($message->type === 'template')
                                                <strong>Template: {{ $message->template_name }}</strong>
                                            @else
                                                {{ Str::limit($message->content, 50) }}
                                            @endif
                                        </td>
                                        <td>
                                            @switch($message->status)
                                                @case('queued')
                                                    <span class="badge bg-warning">Queued</span>
                                                    @break
                                                @case('sent')
                                                    <span class="badge bg-info">Sent</span>
                                                    @break
                                                @case('delivered')
                                                    <span class="badge bg-success">Delivered</span>
                                                    @break
                                                @case('read')
                                                    <span class="badge bg-primary">Read</span>
                                                    @break
                                                @case('failed')
                                                    <span class="badge bg-danger">Failed</span>
                                                    @break
                                                @default
                                                    <span class="badge bg-secondary">{{ $message->status }}</span>
                                            @endswitch
                                        </td>
                                        <td>{{ $message->created_at->diffForHumans() }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-4">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No recent activity</h5>
                        <p class="text-muted">Start conversations with customers to see activity here.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}
.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}
.border-left-info {
    border-left: 0.25rem solid #36b9cc !important;
}
.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}
.text-gray-300 {
    color: #dddfeb !important;
}
.text-gray-800 {
    color: #5a5c69 !important;
}
</style>
@endpush
@endsection
