@extends('layouts.app')

@section('title', 'Conversation with ' . $customerE164)

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="fab fa-whatsapp me-2 text-success"></i>
                    {{ $customerE164 }}
                </h5>
                <div>
                    <a href="{{ route('agent.inbox') }}" class="btn btn-outline-secondary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i>
                        Back to Inbox
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Messages Container -->
                <div class="messages-container" style="height: 400px; overflow-y: auto; border: 1px solid #dee2e6; border-radius: 0.375rem; padding: 1rem; margin-bottom: 1rem;">
                    @foreach($messages as $message)
                        <div class="message {{ $message->direction === 'inbound' ? 'inbound' : 'outbound' }} mb-3">
                            <div class="d-flex {{ $message->direction === 'inbound' ? 'justify-content-start' : 'justify-content-end' }}">
                                <div class="message-bubble {{ $message->direction === 'inbound' ? 'bg-light' : 'bg-primary text-white' }}" 
                                     style="max-width: 70%; padding: 0.75rem; border-radius: 1rem; word-wrap: break-word;">
                                    <div class="message-content">
                                        @if($message->type === 'template')
                                            <strong>Template: {{ $message->template_name }}</strong><br>
                                            @if($message->params)
                                                <small class="text-muted">Parameters: {{ json_encode($message->params) }}</small>
                                            @endif
                                        @else
                                            {{ $message->content }}
                                        @endif
                                    </div>
                                    <div class="message-meta mt-1">
                                        <small class="{{ $message->direction === 'inbound' ? 'text-muted' : 'text-light' }}">
                                            {{ $message->created_at->format('M j, g:i A') }}
                                            @if($message->direction === 'outbound')
                                                <span class="ms-2">
                                                    @switch($message->status)
                                                        @case('queued')
                                                            <i class="fas fa-clock text-warning"></i>
                                                            @break
                                                        @case('sent')
                                                            <i class="fas fa-check text-success"></i>
                                                            @break
                                                        @case('delivered')
                                                            <i class="fas fa-check-double text-success"></i>
                                                            @break
                                                        @case('read')
                                                            <i class="fas fa-check-double text-info"></i>
                                                            @break
                                                        @case('failed')
                                                            <i class="fas fa-times text-danger"></i>
                                                            @break
                                                    @endswitch
                                                </span>
                                            @endif
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Message Input -->
                <form action="{{ route('agent.send.message', $customerE164) }}" method="POST">
                    @csrf
                    <div class="input-group">
                        <textarea class="form-control" 
                                  name="content" 
                                  rows="3" 
                                  placeholder="Type your message..." 
                                  required></textarea>
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-paper-plane"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.messages-container {
    background-color: #f8f9fa;
}
.message-bubble {
    box-shadow: 0 1px 2px rgba(0,0,0,0.1);
}
.inbound .message-bubble {
    border-bottom-left-radius: 0.25rem;
}
.outbound .message-bubble {
    border-bottom-right-radius: 0.25rem;
}
</style>
@endpush

@push('scripts')
<script>
// Auto-scroll to bottom of messages
const messagesContainer = document.querySelector('.messages-container');
messagesContainer.scrollTop = messagesContainer.scrollHeight;

// Auto-refresh conversation every 10 seconds
setInterval(function() {
    location.reload();
}, 10000);
</script>
@endpush
@endsection
