@extends('layouts.app')

@section('title', 'Admin Settings')

@section('content')
<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-cog me-2"></i>
                    WhatsApp Configuration
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.settings.update') }}" method="POST">
                    @csrf
                    
                    <div class="mb-3">
                        <label for="meta_access_token" class="form-label">Meta Access Token</label>
                        <input type="password" 
                               class="form-control @error('meta_access_token') is-invalid @enderror" 
                               id="meta_access_token" 
                               name="meta_access_token" 
                               value="{{ $settings->meta_access_token ?? '' }}" 
                               required>
                        <div class="form-text">Your permanent access token from Meta Developer Console</div>
                        @error('meta_access_token')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="phone_number_id" class="form-label">Phone Number ID</label>
                        <input type="text" 
                               class="form-control @error('phone_number_id') is-invalid @enderror" 
                               id="phone_number_id" 
                               name="phone_number_id" 
                               value="{{ $settings->phone_number_id ?? '' }}" 
                               required>
                        <div class="form-text">Your WhatsApp Business Phone Number ID</div>
                        @error('phone_number_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label for="default_agent_id" class="form-label">Default Agent</label>
                        <select class="form-select @error('default_agent_id') is-invalid @enderror" 
                                id="default_agent_id" 
                                name="default_agent_id">
                            <option value="">Select Default Agent</option>
                            @foreach($agents as $agent)
                                <option value="{{ $agent->id }}" 
                                        {{ ($settings->default_agent_id ?? '') == $agent->id ? 'selected' : '' }}>
                                    {{ $agent->username }}
                                </option>
                            @endforeach
                        </select>
                        <div class="form-text">Agent to assign new customers by default</div>
                        @error('default_agent_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>
                            Save Settings
                        </button>
                        
                        <form action="{{ route('admin.sync.templates') }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" 
                                    class="btn btn-outline-primary"
                                    onclick="return confirm('Sync templates from WhatsApp?')">
                                <i class="fas fa-sync me-2"></i>
                                Sync Templates
                            </button>
                        </form>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>
                    Templates ({{ $templates->count() }})
                </h5>
            </div>
            <div class="card-body">
                @if($templates->count() > 0)
                    <div class="list-group list-group-flush">
                        @foreach($templates as $template)
                            <div class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>{{ $template->name }}</strong>
                                    <br>
                                    <small class="text-muted">{{ $template->language }} • {{ $template->category }}</small>
                                </div>
                                <span class="badge bg-success rounded-pill">Active</span>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center text-muted">
                        <i class="fas fa-inbox fa-3x mb-3"></i>
                        <p>No templates synced yet.</p>
                        <p class="small">Click "Sync Templates" to import from WhatsApp.</p>
                    </div>
                @endif
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Webhook URL
                </h5>
            </div>
            <div class="card-body">
                <div class="input-group">
                    <input type="text" 
                           class="form-control" 
                           value="{{ url('/api/webhook') }}" 
                           readonly>
                    <button class="btn btn-outline-secondary" 
                            type="button" 
                            onclick="copyToClipboard(this)">
                        <i class="fas fa-copy"></i>
                    </button>
                </div>
                <div class="form-text mt-2">
                    Use this URL in your Meta Developer Console webhook configuration.
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function copyToClipboard(button) {
    const input = button.parentElement.querySelector('input');
    input.select();
    document.execCommand('copy');
    
    const icon = button.querySelector('i');
    icon.className = 'fas fa-check';
    setTimeout(() => {
        icon.className = 'fas fa-copy';
    }, 2000);
}
</script>
@endpush
@endsection
