@extends('layouts.app')

@section('title', 'Admin Dashboard')

@section('content')
<div class="row">
    <!-- Statistics Cards -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total Users
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['total_users'] }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Active Agents
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['active_agents'] }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-user-tie fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Templates
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['total_templates'] }}</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            System Status
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">Online</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-server fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Recent Activity -->
    <div class="col-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">Recent System Activity</h6>
                <div>
                    <a href="{{ route('admin.settings') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-cog me-1"></i>
                        Settings
                    </a>
                    <a href="{{ route('admin.users') }}" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-users me-1"></i>
                        Manage Users
                    </a>
                </div>
            </div>
            <div class="card-body">
                @if(count($stats['recent_audit_logs']) > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Time</th>
                                    <th>User</th>
                                    <th>Action</th>
                                    <th>Details</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($stats['recent_audit_logs'] as $log)
                                    <tr>
                                        <td>{{ $log->created_at->format('M j, g:i A') }}</td>
                                        <td>
                                            @if($log->actor)
                                                {{ $log->actor->username }}
                                            @else
                                                <span class="text-muted">System</span>
                                            @endif
                                        </td>
                                        <td>
                                            @switch($log->action)
                                                @case('user_login')
                                                    <span class="badge bg-success">Login</span>
                                                    @break
                                                @case('user_logout')
                                                    <span class="badge bg-secondary">Logout</span>
                                                    @break
                                                @case('settings_updated')
                                                    <span class="badge bg-info">Settings Updated</span>
                                                    @break
                                                @case('templates_synced')
                                                    <span class="badge bg-primary">Templates Synced</span>
                                                    @break
                                                @case('template_message_sent')
                                                    <span class="badge bg-success">Message Sent</span>
                                                    @break
                                                @case('inbound_message_received')
                                                    <span class="badge bg-warning">Message Received</span>
                                                    @break
                                                @default
                                                    <span class="badge bg-secondary">{{ $log->action }}</span>
                                            @endswitch
                                        </td>
                                        <td>
                                            @if($log->details)
                                                <small class="text-muted">
                                                    @if(isset($log->details['username']))
                                                        User: {{ $log->details['username'] }}
                                                    @endif
                                                    @if(isset($log->details['template']))
                                                        Template: {{ $log->details['template'] }}
                                                    @endif
                                                    @if(isset($log->details['to']))
                                                        To: {{ $log->details['to'] }}
                                                    @endif
                                                    @if(isset($log->details['count']))
                                                        Count: {{ $log->details['count'] }}
                                                    @endif
                                                </small>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-4">
                        <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No recent activity</h5>
                        <p class="text-muted">System activity will appear here as users interact with the CRM.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Quick Actions -->
    <div class="col-lg-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Quick Actions</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('admin.settings') }}" class="btn btn-outline-primary w-100">
                            <i class="fas fa-cog fa-2x mb-2"></i><br>
                            Configure Settings
                        </a>
                    </div>
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('admin.users') }}" class="btn btn-outline-success w-100">
                            <i class="fas fa-users fa-2x mb-2"></i><br>
                            Manage Users
                        </a>
                    </div>
                    <div class="col-md-6 mb-3">
                        <form action="{{ route('admin.sync.templates') }}" method="POST" class="d-inline w-100">
                            @csrf
                            <button type="submit" class="btn btn-outline-info w-100">
                                <i class="fas fa-sync fa-2x mb-2"></i><br>
                                Sync Templates
                            </button>
                        </form>
                    </div>
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('messages.compose') }}" class="btn btn-outline-warning w-100">
                            <i class="fas fa-paper-plane fa-2x mb-2"></i><br>
                            Send Message
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- System Info -->
    <div class="col-lg-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">System Information</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-12 mb-3">
                        <strong>Application:</strong> {{ config('app.name') }}<br>
                        <strong>Environment:</strong> {{ config('app.env') }}<br>
                        <strong>Version:</strong> Laravel {{ app()->version() }}<br>
                        <strong>PHP Version:</strong> {{ PHP_VERSION }}
                    </div>
                    <div class="col-12">
                        <strong>Database:</strong> {{ config('database.default') }}<br>
                        <strong>Queue Driver:</strong> {{ config('queue.default') }}<br>
                        <strong>Cache Driver:</strong> {{ config('cache.default') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}
.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}
.border-left-info {
    border-left: 0.25rem solid #36b9cc !important;
}
.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}
.text-gray-300 {
    color: #dddfeb !important;
}
.text-gray-800 {
    color: #5a5c69 !important;
}
</style>
@endpush
@endsection
