<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('crm_messages', function (Blueprint $table) {
            $table->id();
            $table->string('customer_e164');
            $table->unsignedBigInteger('agent_id')->nullable();
            $table->enum('direction', ['outbound', 'inbound']);
            $table->enum('type', ['template', 'text', 'media']);
            $table->string('template_name')->nullable();
            $table->json('params')->nullable();
            $table->text('content')->nullable();
            $table->enum('status', ['queued', 'sent', 'delivered', 'read', 'failed'])->default('queued');
            $table->string('error_reason')->nullable();
            $table->string('provider_message_id')->nullable();
            $table->timestamps();
            
            $table->foreign('agent_id')->references('id')->on('crm_users')->onDelete('set null');
            $table->index(['customer_e164', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('crm_messages');
    }
};
