<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('crm_agent_assignments', function (Blueprint $table) {
            $table->id();
            $table->string('customer_e164');
            $table->unsignedBigInteger('agent_id');
            $table->timestamps();
            
            $table->unique('customer_e164');
            $table->foreign('agent_id')->references('id')->on('crm_users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('crm_agent_assignments');
    }
};
