<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Hash;

class CrmUser extends Model
{
    use HasFactory;

    protected $table = 'crm_users';
    
    protected $fillable = [
        'username',
        'password',
        'role',
        'active'
    ];

    protected $hidden = [
        'password',
    ];

    protected $casts = [
        'active' => 'boolean',
    ];

    public function messages()
    {
        return $this->hasMany(CrmMessage::class, 'agent_id');
    }

    public function assignments()
    {
        return $this->hasMany(CrmAgentAssignment::class, 'agent_id');
    }

    public function auditLogs()
    {
        return $this->hasMany(CrmAuditLog::class, 'actor_user_id');
    }

    public function isAdmin()
    {
        return $this->role === 'Admin';
    }

    public function isAgent()
    {
        return $this->role === 'Agent';
    }

    public function setPasswordAttribute($value)
    {
        $this->attributes['password'] = Hash::make($value);
    }

    public function getAssignedCustomers()
    {
        return $this->assignments()->pluck('customer_e164');
    }
}
