<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CrmTemplate extends Model
{
    use HasFactory;

    protected $table = 'crm_templates';
    
    protected $fillable = [
        'name',
        'language',
        'category',
        'template_data',
        'synced_at'
    ];

    protected $casts = [
        'template_data' => 'array',
        'synced_at' => 'datetime',
    ];

    public function scopeActive($query)
    {
        return $query->whereNotNull('synced_at');
    }

    public function scopeByLanguage($query, $language = 'en')
    {
        return $query->where('language', $language);
    }

    public function scopeByCategory($query, $category)
    {
        return $query->where('category', $category);
    }
}
