<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CrmSetting extends Model
{
    use HasFactory;

    protected $table = 'crm_settings';
    
    protected $fillable = [
        'meta_access_token',
        'phone_number_id',
        'default_agent_id'
    ];

    protected $hidden = [
        'meta_access_token',
    ];

    public function defaultAgent()
    {
        return $this->belongsTo(CrmUser::class, 'default_agent_id');
    }

    public static function getSettings()
    {
        return static::first() ?? new static();
    }

    public function updateSettings($data)
    {
        $this->fill($data);
        $this->save();
        return $this;
    }
}
