<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CrmMessage extends Model
{
    use HasFactory;

    protected $table = 'crm_messages';
    
    protected $fillable = [
        'customer_e164',
        'agent_id',
        'direction',
        'type',
        'template_name',
        'params',
        'content',
        'status',
        'error_reason',
        'provider_message_id'
    ];

    protected $casts = [
        'params' => 'array',
    ];

    public function agent()
    {
        return $this->belongsTo(CrmUser::class, 'agent_id');
    }

    public function assignment()
    {
        return $this->belongsTo(CrmAgentAssignment::class, 'customer_e164', 'customer_e164');
    }

    public function scopeInbound($query)
    {
        return $query->where('direction', 'inbound');
    }

    public function scopeOutbound($query)
    {
        return $query->where('direction', 'outbound');
    }

    public function scopeForCustomer($query, $customerE164)
    {
        return $query->where('customer_e164', $customerE164);
    }

    public function scopeForAgent($query, $agentId)
    {
        return $query->where('agent_id', $agentId);
    }

    public function scopeByStatus($query, $status)
    {
        return $query->where('status', $status);
    }

    public function isInbound()
    {
        return $this->direction === 'inbound';
    }

    public function isOutbound()
    {
        return $this->direction === 'outbound';
    }

    public function isTemplate()
    {
        return $this->type === 'template';
    }

    public function isText()
    {
        return $this->type === 'text';
    }

    public function isMedia()
    {
        return $this->type === 'media';
    }
}
