<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CrmAuditLog extends Model
{
    use HasFactory;

    protected $table = 'crm_audit_logs';
    
    protected $fillable = [
        'actor_user_id',
        'action',
        'details'
    ];

    protected $casts = [
        'details' => 'array',
    ];

    public function actor()
    {
        return $this->belongsTo(CrmUser::class, 'actor_user_id');
    }

    public static function log($action, $details = [], $actorUserId = null)
    {
        return static::create([
            'actor_user_id' => $actorUserId,
            'action' => $action,
            'details' => $details,
        ]);
    }

    public function scopeByAction($query, $action)
    {
        return $query->where('action', $action);
    }

    public function scopeByActor($query, $actorUserId)
    {
        return $query->where('actor_user_id', $actorUserId);
    }
}
