<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CrmAgentAssignment extends Model
{
    use HasFactory;

    protected $table = 'crm_agent_assignments';
    
    protected $fillable = [
        'customer_e164',
        'agent_id'
    ];

    public function agent()
    {
        return $this->belongsTo(CrmUser::class, 'agent_id');
    }

    public function messages()
    {
        return $this->hasMany(CrmMessage::class, 'customer_e164', 'customer_e164');
    }

    public static function assignCustomerToAgent($customerE164, $agentId)
    {
        return static::updateOrCreate(
            ['customer_e164' => $customerE164],
            ['agent_id' => $agentId]
        );
    }

    public static function getAgentForCustomer($customerE164)
    {
        $assignment = static::where('customer_e164', $customerE164)->first();
        return $assignment ? $assignment->agent : null;
    }
}
