<?php

namespace App\Jobs;

use App\Services\MetaService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class SyncTemplatesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $tries = 3;
    public $timeout = 60;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(MetaService $metaService): void
    {
        try {
            Log::info('Starting template sync job');
            
            $result = $metaService->syncTemplates();
            
            if ($result['success']) {
                Log::info("Template sync completed successfully. Synced {$result['count']} templates.");
            } else {
                Log::error("Template sync failed: " . $result['message']);
                throw new \Exception($result['message']);
            }

        } catch (\Exception $e) {
            Log::error("SyncTemplatesJob failed: " . $e->getMessage());
            throw $e;
        }
    }

    /**
     * Handle a job failure.
     */
    public function failed(\Throwable $exception): void
    {
        Log::error("SyncTemplatesJob failed permanently: " . $exception->getMessage());
    }
}
