# Mahara WhatsApp CRM

A complete Laravel-based WhatsApp CRM system with role-based access control, template messaging, and automated customer routing.

## Features

- **Role-based Authentication**: Admin and Agent roles with different permissions
- **WhatsApp Integration**: Meta WhatsApp Cloud API integration
- **Template Management**: Sync and send WhatsApp message templates
- **Customer Routing**: Automatic assignment of customers to agents
- **Message History**: Complete conversation tracking
- **Queue System**: Background job processing for message sending
- **Webhook Handling**: Real-time message reception and status updates
- **Audit Logging**: Complete system activity tracking

## System Requirements

- PHP 8.2+
- Laravel 11
- SQL Server or MySQL
- Composer
- Windows (XAMPP/IIS)

## Installation

### 1. Clone and Setup

```bash
# Navigate to your web server directory
cd C:\xampp\htdocs

# Clone or extract the project
# Ensure the project is in: C:\xampp\htdocs\maharaCRM

# Navigate to project directory
cd maharaCRM
```

### 2. Install Dependencies

```bash
composer install
```

### 3. Environment Configuration

Copy the `.env.example` to `.env` and configure:

```env
APP_NAME="Mahara WhatsApp CRM"
APP_ENV=local
APP_KEY=base64:your-app-key-here
APP_DEBUG=true
APP_URL=http://localhost

# Database Configuration (SQL Server)
DB_CONNECTION=sqlsrv
DB_HOST=127.0.0.1
DB_PORT=1433
DB_DATABASE=WhatsappCRM
DB_USERNAME=sa
DB_PASSWORD=YourStrong!Pass

# MySQL Alternative (uncomment if using MySQL)
# DB_CONNECTION=mysql
# DB_HOST=127.0.0.1
# DB_PORT=3306
# DB_DATABASE=WhatsappCRM
# DB_USERNAME=root
# DB_PASSWORD=

# WhatsApp CRM Settings
META_VERIFY_TOKEN=XYZ_VERIFY
META_PHONE_NUMBER_ID=123456789012345
META_ACCESS_TOKEN=EAAB...
META_WEBHOOK_URL=https://your-domain.com/webhook
```

### 4. Database Setup

```bash
# Run migrations
php artisan migrate

# Seed initial users
php artisan db:seed
```

### 5. Queue Setup

```bash
# Create queue tables
php artisan queue:table
php artisan migrate

# Start queue worker (in background)
php artisan queue:work --daemon
```

### 6. Webhook Configuration

1. Go to Meta Developer Console
2. Configure your WhatsApp app
3. Set webhook URL: `https://your-domain.com/api/webhook`
4. Set verify token: `XYZ_VERIFY`

## Default Users

After seeding, you'll have these users:

- **Admin**: `admin` / `Admin@123`
- **Agent**: `agent1` / `Agent@123`

## Usage

### Admin Functions

1. **Login** as admin
2. **Configure Settings**:
   - Meta Access Token
   - Phone Number ID
   - Default Agent
3. **Sync Templates** from WhatsApp
4. **Manage Users** (create/edit/delete agents)

### Agent Functions

1. **Login** as agent
2. **View Inbox** with assigned customers
3. **Send Messages** to customers
4. **View Conversation History**

### Message Sending

1. **Template Messages**: Use pre-approved WhatsApp templates
2. **Text Messages**: Send free-form text messages
3. **Queue Processing**: Messages are sent in background

## File Structure

```
maharaCRM/
├── app/
│   ├── Http/Controllers/
│   │   ├── AccountController.php      # Authentication
│   │   ├── AdminController.php        # Admin functions
│   │   ├── AgentController.php        # Agent functions
│   │   ├── MessagesController.php     # Message management
│   │   └── WebhookController.php      # WhatsApp webhooks
│   ├── Jobs/
│   │   ├── SendTemplateJob.php        # Background message sending
│   │   └── SyncTemplatesJob.php       # Template synchronization
│   ├── Models/
│   │   ├── CrmUser.php               # User management
│   │   ├── CrmSetting.php            # System settings
│   │   ├── CrmTemplate.php           # Message templates
│   │   ├── CrmMessage.php            # Message storage
│   │   ├── CrmAgentAssignment.php    # Customer-agent mapping
│   │   └── CrmAuditLog.php           # Activity logging
│   └── Services/
│       ├── MetaService.php           # WhatsApp API integration
│       └── RoutingService.php        # Customer routing logic
├── database/
│   ├── migrations/                   # Database schema
│   └── seeders/
│       └── CrmUserSeeder.php         # Initial user data
├── resources/views/
│   ├── layouts/
│   │   └── app.blade.php             # Main layout
│   ├── auth/
│   │   └── login.blade.php           # Login page
│   ├── admin/                        # Admin views
│   ├── agent/                        # Agent views
│   └── messages/                     # Message views
└── routes/
    ├── web.php                       # Web routes
    └── api.php                       # API routes (webhooks)
```

## Database Tables

- `crm_users`: Admin and Agent users
- `crm_settings`: WhatsApp configuration
- `crm_templates`: Message templates
- `crm_agent_assignments`: Customer-agent mappings
- `crm_messages`: All messages (inbound/outbound)
- `crm_audit_logs`: System activity tracking

## Windows/XAMPP Commands

### Start Services
```bash
# Start XAMPP Control Panel
# Start Apache and MySQL/SQL Server

# Navigate to project
cd C:\xampp\htdocs\maharaCRM

# Start queue worker
php artisan queue:work --daemon

# Start scheduler (optional)
php artisan schedule:work
```

### Development Commands
```bash
# Clear caches
php artisan config:clear
php artisan cache:clear
php artisan view:clear

# Regenerate autoload
composer dump-autoload

# Check routes
php artisan route:list

# Monitor logs
tail -f storage/logs/laravel.log
```

## Security Considerations

1. **Environment Variables**: Keep sensitive data in `.env`
2. **Access Tokens**: Secure your Meta access tokens
3. **Webhook Security**: Use HTTPS for webhook URLs
4. **User Permissions**: Implement proper role-based access
5. **Database Security**: Use strong database passwords

## Troubleshooting

### Common Issues

1. **Queue Not Working**:
   ```bash
   php artisan queue:work --daemon
   ```

2. **Database Connection**:
   - Check `.env` configuration
   - Ensure database server is running
   - Verify credentials

3. **Webhook Not Receiving**:
   - Check webhook URL is accessible
   - Verify verify token matches
   - Check server logs

4. **Template Sync Failing**:
   - Verify access token is valid
   - Check phone number ID
   - Ensure templates are approved

### Logs

Check logs for debugging:
- `storage/logs/laravel.log`
- Queue worker logs
- Web server error logs

## Support

For issues and questions:
1. Check the logs
2. Verify configuration
3. Test with sample data
4. Review Meta API documentation

## License

This project is for educational and commercial use.
