<?php
require_once 'db.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Inbox - WhatsApp Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .chat-box { height: 70vh; overflow-y: scroll; background-color: #fff; padding: 10px; border-radius: 10px; }
        .chat-bubble { margin: 5px 0; padding: 10px; border-radius: 10px; }
        .me { background-color: #d1e7dd; text-align: right; }
        .client { background-color: #f8d7da; text-align: left; }
        .unread { background-color: #fff3cd !important; }
        #popupNotification {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background: #0d6efd;
            color: white;
            padding: 10px 20px;
            border-radius: 10px;
            display: none;
            z-index: 9999;
        }
    </style>
</head>
<body>
<div class="container mt-4">
    <div class="row">
        <div class="col-md-3">
            <h5>Inbox</h5>
            <input type="text" id="searchInput" class="form-control mb-2" placeholder="Search...">
            <ul class="list-group" id="contactList"></ul>
            <nav>
                <ul class="pagination justify-content-center mt-2" id="pagination"></ul>
            </nav>
        </div>
        <div class="col-md-9">
            <h5 id="chatTitle">Select a conversation</h5>
            <div id="chatBox" class="chat-box mb-3"></div>
        </div>
    </div>
</div>
<audio id="pingSound" src="ping.mp3" preload="auto" muted></audio>
<div id="popupNotification"></div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
let allContacts = [];
let currentNumber = '';
let currentPage = 1;
const itemsPerPage = 20;
let refreshInterval;

function loadContacts() {
    $.getJSON('get_contacts.php', function(data) {
        allContacts = data;
        let hasNew = false;
        let newMessages = [];

        data.forEach(c => {
            if (c.unread > 0) {
                hasNew = true;
                newMessages.push(c.display_name ? c.display_name : c.whatsapp_number);
            }
        });

        renderContacts();

        if (hasNew) {
            const ping = document.getElementById('pingSound');
            ping.muted = false;
            ping.play();

            const popup = document.getElementById('popupNotification');
            popup.innerText = "📨 New message from: " + newMessages.join(", ");
            popup.style.display = "block";
            setTimeout(() => popup.style.display = "none", 5000);
        }
    });
}

function renderContacts() {
    let search = $('#searchInput').val().toLowerCase();
    let filtered = allContacts.filter(c =>
        (c.display_name && c.display_name.toLowerCase().includes(search)) ||
        c.whatsapp_number.includes(search)
    );

    let totalPages = Math.ceil(filtered.length / itemsPerPage);
    currentPage = Math.min(currentPage, totalPages || 1);
    let start = (currentPage - 1) * itemsPerPage;
    let currentContacts = filtered.slice(start, start + itemsPerPage);

    $('#contactList').html('');
    currentContacts.forEach(contact => {
        let label = (contact.display_name ? contact.display_name : '') + ' (' + contact.whatsapp_number + ')';
        let unreadClass = contact.unread > 0 ? 'unread' : '';
        let badge = contact.unread > 0 ? `<span class='badge bg-danger float-end'>${contact.unread}</span>` : '';
        $('#contactList').append(`<li class="list-group-item contact ${unreadClass}" data-number="${contact.whatsapp_number}">${label} ${badge}</li>`);
    });

    let pagination = '';
    for (let i = 1; i <= totalPages; i++) {
        pagination += `<li class="page-item ${i === currentPage ? 'active' : ''}"><a class="page-link" href="#">${i}</a></li>`;
    }
    $('#pagination').html(pagination);

    bindContacts();
}

function bindContacts() {
    $('.contact').click(function() {
        clearInterval(refreshInterval);
        currentNumber = $(this).data('number');
        $('#chatTitle').text("Chat with " + currentNumber);
        $('.contact').removeClass('active');
        $(this).addClass('active').removeClass('unread');

        $.post('mark_as_read.php', { number: currentNumber });

        function loadMessages() {
            $.get('get_messages.php', { number: currentNumber }, function(data) {
                $('#chatBox').html(data);
                $('#chatBox').scrollTop($('#chatBox')[0].scrollHeight);
            });
        }

        loadMessages();
        refreshInterval = setInterval(loadMessages, 3000);
    });
}

$('#pagination').on('click', 'a', function(e) {
    e.preventDefault();
    currentPage = parseInt($(this).text());
    renderContacts();
});

$('#searchInput').on('input', function() {
    currentPage = 1;
    renderContacts();
});

loadContacts();
setInterval(loadContacts, 5000);
</script>
</body>
</html>
