<?php
require_once 'db.php';
$number = $_GET['number'] ?? '';
$stmt = $pdo->prepare("SELECT * FROM history WHERE whatsapp_number = ? ORDER BY created_on ASC");
$stmt->execute([$number]);
$messages = $stmt->fetchAll();

foreach ($messages as $msg) {
    $class = $msg['author'] === 'System' ? 'me' : 'client';
    echo "<div class='chat-bubble $class'>";
    echo "<small>" . $msg['created_on'] . "</small><br>";
    if ($msg['media_path']) {
        $ext = pathinfo($msg['media_path'], PATHINFO_EXTENSION);
        if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif'])) {
            echo "<img src='{$msg['media_path']}' width='150'><br>";
        } elseif (in_array($ext, ['mp4', 'mov'])) {
            echo "<video width='150' controls src='{$msg['media_path']}'></video><br>";
        } elseif (in_array($ext, ['mp3', 'ogg', 'wav'])) {
            echo "<audio controls src='{$msg['media_path']}'></audio><br>";
        } else {
            echo "<a href='{$msg['media_path']}' download>Download File</a><br>";
        }
    }
    echo htmlspecialchars($msg['message']);
    echo "</div>";
}
?>
