<?php
require_once 'db.php';
$contacts = $pdo->query("
    SELECT whatsapp_number, display_name, MAX(created_on) as last_message 
    FROM history 
    GROUP BY whatsapp_number, display_name 
    ORDER BY last_message DESC
")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>WhatsApp Chat</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .chat-box { height: 70vh; overflow-y: scroll; background-color: #fff; padding: 10px; border-radius: 10px; }
        .chat-bubble { margin: 5px 0; padding: 10px; border-radius: 10px; }
        .me { background-color: #d1e7dd; text-align: right; }
        .client { background-color: #f8d7da; text-align: left; }
    </style>
</head>
<body>
<div class="container mt-4">
    <div class="row">
        <!-- Contacts -->
        <div class="col-md-3">
            <h5>Contacts</h5>
            <ul class="list-group" id="contactList">
                <?php foreach($contacts as $contact): ?>
                    <li class="list-group-item contact" data-number="<?= $contact['whatsapp_number'] ?>">
                        <?= $contact['display_name'] ?: $contact['whatsapp_number'] ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
        <!-- Chat Window -->
        <div class="col-md-9">
            <h5 id="chatTitle">Select a contact</h5>
            <div id="chatBox" class="chat-box mb-3"></div>
            <form id="sendForm" enctype="multipart/form-data">
                <input type="hidden" name="whatsapp_number" id="whatsapp_number">
                <div class="input-group mb-2">
                    <input type="text" name="message" class="form-control" placeholder="Type a message">
                    <input type="file" name="file" class="form-control">
                    <button type="submit" class="btn btn-primary">Send</button>
                </div>
            </form>
            <div class="mt-2">
                <button class="btn btn-outline-secondary template">Hello</button>
                <button class="btn btn-outline-secondary template">شكرا لتواصلك</button>
                <button class="btn btn-outline-secondary template">سيتم التواصل معك</button>
            </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
let currentNumber = '';
let refreshInterval;

function loadMessages() {
    if (currentNumber !== '') {
        $.get('get_messages.php', { number: currentNumber }, function(data) {
            $('#chatBox').html(data);
            $('#chatBox').scrollTop($('#chatBox')[0].scrollHeight);
        });
    }
}

function bindContacts() {
    $('.contact').click(function() {
        clearInterval(refreshInterval);
        currentNumber = $(this).data('number');
        $('#whatsapp_number').val(currentNumber);
        $('#chatTitle').text("Chat with " + currentNumber);
        loadMessages();
        refreshInterval = setInterval(loadMessages, 3000);
    });
}

function loadContacts() {
    $.get('get_contacts.php', function(data) {
        $('#contactList').html(data);
        bindContacts();
        if (currentNumber !== '') {
            $('#whatsapp_number').val(currentNumber);
            $('#chatTitle').text("Chat with " + currentNumber);
        }
    });
}

$('#sendForm').submit(function(e) {
    e.preventDefault();
    $.ajax({
        url: 'send_message.php',
        method: 'POST',
        data: new FormData(this),
        contentType: false,
        processData: false,
        success: function() {
            loadMessages();
            $('#sendForm')[0].reset();
        }
    });
});

$('.template').click(function() {
    $('input[name="message"]').val($(this).text());
});

loadContacts();
setInterval(loadContacts, 5000);
</script>
</body>
</html>
